 /* 'mrTemplateSet.cpp' */

 /* Komplementarny plik nagwka */
#include "mrTemplateSet.h"

 /* Konstruktor domylny */
mrTemplateSet::mrTemplateSet (void)
{
 m_pkTexture       = NULL;
 m_iTextureWidth   = 0;
 m_iTextureHeight  = 0;
 m_iCellWidth      = 0;
 m_iCellHeight     = 0;
}

 /* Destruktor domylny */
mrTemplateSet::~mrTemplateSet (void)
{
 m_iTextureWidth   = 0;
 m_iTextureHeight  = 0;
 m_iCellWidth      = 0;
 m_iCellHeight     = 0;
 m_pkTexture       = NULL;
}

 /* Utwrz zestaw szablonw */
void mrTemplateSet::Create (mrTexture * pkTexture, 
                            mrUInt32 iTextureWidth, 
                            mrUInt32 iTextureHeight, 
                            mrUInt32 iCellWidth, 
                            mrUInt32 iCellHeight)
{
 m_iTextureWidth  = iTextureWidth;
 m_iTextureHeight = iTextureHeight;
 m_iCellWidth     = iCellWidth;
 m_iCellHeight    = iCellHeight;

 m_pkTexture      = pkTexture;
}

 /* Zwraca UVrect tesktury dla danej komrki */
void mrTemplateSet::GetUV (mrCellID kPosition, mrRectText * pkUVRect)
{
 pkUVRect->m_fLeft   = (mrReal32)(1 + ((1 + m_iCellWidth) 
  * kPosition.m_iX)) / m_iTextureWidth;
 pkUVRect->m_fRight  = (mrReal32)(1 + ((1 + m_iCellWidth) 
  * kPosition.m_iX) + m_iCellWidth) / m_iTextureWidth;
 pkUVRect->m_fTop    = (mrReal32)(1 + ((1 + m_iCellHeight) 
  * kPosition.m_iY)) / m_iTextureHeight;
 pkUVRect->m_fBottom = (mrReal32)(1 + ((1 + m_iCellHeight) 
  * kPosition.m_iY) + m_iCellHeight) / m_iTextureHeight;
}

 /* Ustawia jako tesktur aktywn */
void mrTemplateSet::SetActiveTexture (void)
{
 m_pkTexture->SetActiveTexture ();
}

 /* Zwraca szeroko tekstury */
mrUInt32 mrTemplateSet::GetTextureWidth (void)
{
 return m_iTextureWidth;
}

 /* Zwraca wysoko tesktury */
mrUInt32 mrTemplateSet::GetTextureHeight (void)
{
 return m_iTextureHeight;
}

 /* Zwraca szeroko komrki */
mrUInt32 mrTemplateSet::GetCellWidth (void)
{
 return m_iCellWidth;
}

 /* Zwraca wysoko komrki */
mrUInt32 mrTemplateSet::GetCellHeight (void)
{
 return m_iCellHeight;
}
